# -*- encoding=utf-8 -*-
import pyvisa
import time
from PyQt5.QtCore import *
import os
from comPort import *
import re
import openpyxl
import datetime

timeStep = 1   #1 second
tcShiftPoint = 25 #Add Tc shift time to reduce the TC calcualtion jump, may need to change accoridng to the test result
compress = 1  #Compress 4s data to 1 data
terminateCurtThd = 0.002 #Judge when the battery is rest

senseMode = 1 #0 means 2 wire mode, 1 means 4 wire mode
runTimeStep_s = 1
restTimeStep_s = 1
currentLimit_A = 3
voltageLimit_V = 4.3
battCapacity = 3100 #mAh
smCloseDischarge = 1.05

class Thread_SmComToolHandle(QThread):
    signalComPort = pyqtSignal(str) #Com port name
    signalTestDone = pyqtSignal(int) #test control
    signalComData = pyqtSignal(list) #Com data list
    signalComLog  = pyqtSignal(str) #Com port status

    def __init__(self):
        super(Thread_SmComToolHandle, self).__init__()
        self.comPort = COM()
        self.excelInit()
        self.lastListPort = "None"
        self.comName = "None"
        self.baudRate = 9600
        self.icell_mA = 0
        self.vcell_mV = 0
        self.testcaseMode = 0
        self.portOpenFlag = 0
        self.startTestFlag = 0

    def testcase_GetSocOcvTable(self):

        self.batteryCharging(4350,0.6*battCapacity,0.02*battCapacity)
        self.batteryRest(3600)
        self.pluseCurrent(-0.1*battCapacity,-0.1*battCapacity,3600,2450,4400,1200,7200)
        self.pluseCurrent(0.1 * battCapacity, 0.1 * battCapacity, 3600, 2450, 4400, 1200, 7200)
        self.batteryRest(7200)

    def testcase_BattCharging(self):
        self.batteryCharging(4200,0.6*battCapacity,0.05*battCapacity)
        self.batteryRest(7200)

    def testcase_CurrentPerformanceTest(self):
        self.batteryCharging(4000, 0.6 * battCapacity, 0.1 * battCapacity)
        self.batteryRest(600)
        self.changeCurrent(-2000,0,2500,4350,10,4)
        self.batteryRest(600)
        self.constantCurrent(-0.3 * battCapacity,2500,4250)
        self.batteryRest(600)
        self.changeCurrent(0, 2000, 2500, 4400, 10, 4)
        self.batteryRest(600)

        self.constantCurrent(-0.3 * battCapacity,2500,4250)
        self.batteryRest(600)
        self.changeCurrent(2000,0, 2500, 4400, 10, 4)
        self.batteryRest(600)
        self.batteryCharging(4200, 0.6 * battCapacity, 0.05 * battCapacity)
        self.batteryRest(600)
        self.changeCurrent(0,-2000,2500,4350,10,4)
        self.batteryRest(600)

    def testcase_Custom(self):
        self.batteryCharging(4200, 0.6 * battCapacity, 0.02 * battCapacity)
        self.batteryRest(1200)
        self.pluseCurrent(-0.3 * battCapacity, -0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)
        self.pluseCurrent(0.3 * battCapacity, 0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)

        self.pluseCurrent(-0.3 * battCapacity, -0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)
        self.pluseCurrent(0.3 * battCapacity, 0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)

        self.pluseCurrent(-0.3 * battCapacity, -0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)
        self.pluseCurrent(0.3 * battCapacity, 0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(3600)

        self.pluseCurrent(-0.3 * battCapacity, -0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(1200)
        self.pluseCurrent(0.3 * battCapacity, 0.2 * battCapacity, 3600, 2800, 4200, 3600, 1200)
        self.batteryRest(3600)

    def run(self):
        while True:
            # Refresh the port information when new COM port insert
            listPort = self.comPort.list_port()  # list port names on port selection
            if  self.lastListPort != listPort:
                self.signalComPort.emit("None")#clear the list and then update
                if listPort != "None":  # Port can be find
                    for item in list(listPort):
                        self.signalComPort.emit(item[1])
                if self.lastListPort != listPort:
                    self.lastListPort = listPort

            # When the User click the open com port button, try to connect to source meter
            # if self.comName!= "None" and self.portOpenFlag == 1:
            if self.portOpenFlag == 1:
                idNumRegex = re.compile(r'\d|\d\d|\d\d\d')
                idNum = self.comName[3:] #Find the COM index
                rm = pyvisa.ResourceManager()  # Opens the resource manager and sets it to variable rm
                smuId = "ASRL" +idNum+"::INSTR"
                print(rm.list_resources())
                try:
                    self.inst = rm.open_resource(smuId)
                    self.inst.timeout = 500
                    self.signalComLog.emit(self.inst.query("*IDN?"))  # connect to the device
                    self.inst.write("display.screen = display.SMUA")  # display SMUA
                except:
                    self.signalComLog.emit("Check COM port or close the python code in task manager!")
                self.portOpenFlag = 0#Wait for next click on COM port open button

            if(self.startTestFlag == 1):
                try:
                    self.excelInit()
                    if self.testcaseMode == 0:
                        self.testcase_BattCharging()
                    elif self.testcaseMode ==1:
                        self.testcase_GetSocOcvTable()
                    elif self.testcaseMode ==2:
                        self.testcase_CurrentPerformanceTest()
                    elif self.testcaseMode == 3:
                        self.testcase_Custom()
                    self.excelSave()
                    self.signalTestDone.emit(1)
                    self.signalComLog.emit("Testcase is finished.")
                    self.signalComData.emit([])
                except:
                    if self.startTestFlag == 1:
                        self.signalComLog.emit("Connection failed!")
                        self.signalComData.emit([])
                self.startTestFlag = 0

    def startTest(self,testcaseMode):
        self.endTest()
        self.signalComLog.emit("Test start!")
        self.testcaseMode = testcaseMode
        self.startTestFlag = 1

    def endTest(self,replyEnable = 0):
        if self.startTestFlag == 1:
            self.startTestFlag = 0
            try:
                self.inst.write("smua.source.output =  smua.OUTPUT_OFF")  # Turn off the output.
                # self.inst.write("tspnet.reset()")  # Disconnect the PC
                self.signalComLog.emit("End test succeed!")
                self.signalTestDone.emit(1)
            except:
                self.signalComLog.emit("End test failed!")
        else:
            if replyEnable == 1:
                self.portCloseFlag = 1
                self.startReceiveDataFlag = 0

                self.signalComLog.emit("No test is doing!")
    def openComPort(self, comName):
        self.endTest()
        comNumRegex = re.compile(r'COM\d\d\d|COM\d\d|COM\d')
        self.comName = comNumRegex.search(comName).group()
        self.portOpenFlag = 1
        self.startReceiveDataFlag = 1


    def excelInit(self):
        # init excel
        self.wb = openpyxl.Workbook()
        self.sheet = self.wb["Sheet"]
        self.sheet["A1"] = "Time stamp"
        self.sheet["B1"] = "VCELL(mV)"
        self.sheet["C1"] = "ICELL(mA)"
        self.sheetTitle = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-SmData"
        self.timeStamp = 0
        self.lineCount = 2

    def excelSave(self):
        if self.sheet["A2"].value != None:#check whether there is any data saved
            self.wb.save(self.sheetTitle + '.xlsx')
        self.excelInit()

    def smPerSet(self,chargeVolt_mV,chargeCurrent_mA,voltLimit_mV,currentLimit_mA):
        self.inst.write("smua.reset()")
        if senseMode == 0:  # Reset channel A
            self.inst.write("smua.sense = smua.SENSE_LOCAL")
        else:
            self.inst.write("smua.sense = smua.SENSE_REMOTE")

        if chargeVolt_mV == 0: #Current Source
            self.inst.write("smua.source.func = smua.OUTPUT_DCAMPS")  # Select voltage source function.
            self.inst.write("smua.source.autorangev = smua.AUTORANGE_ON")  # Set current source range to autorange
            self.inst.write("smua.source.limitv = " + str(voltLimit_mV/1000))  # Set voltage limit to  4.3V.
            self.constantCurrentSet(chargeCurrent_mA)
        else:#voltage Source
            self.inst.write("smua.source.func = smua.OUTPUT_DCVOLTS")  # Select voltage source function.
            self.inst.write("smua.source.autorangev = smua.AUTORANGE_ON")  # Set current source range to autorange
            self.inst.write("smua.source.levelv = "+str(chargeVolt_mV/1000))
            self.inst.write("smua.source.limiti = "+str(currentLimit_mA/1000))

        self.inst.write("smua.measure.autorangei = smua.AUTORANGE_ON")                       #Set voltage range to auto.
        self.inst.write("display.smua.measure.func = display.MEASURE_DCAMPS")           #dispaly voltage
        self.inst.write("smua.source.output = smua.OUTPUT_ON")  # Turn on output.
        #Turn on output.

    def smMeasure(self,timeStep):
        list = []
        self.inst.write("display.smua.measure.func = display.MEASURE_DCAMPS")  # dispaly voltage
        self.icell_mA = round(float(self.inst.query('print(smua.measure.i())'))*1000,1)
        self.inst.write("smua.measure.autorangev = smua.AUTORANGE_ON")  # Set voltage range to auto.
        self.inst.write("display.smua.measure.func = display.MEASURE_DCVOLTS")  # dispaly voltage
        self.vcell_mV = round(float(self.inst.query('print(smua.measure.v())'))*1000,1)

        # Save data into excel
        self.sheet["A" + str(self.lineCount)] = self.timeStamp  # Add time stamp
        self.sheet["B" + str(self.lineCount)] = self.vcell_mV
        self.sheet["C" + str(self.lineCount)] = self.icell_mA
        self.timeStamp += timeStep #Update time stamp
        self.lineCount +=1         #Update line count

        # display the data on the GUI
        list.append(self.lineCount-2)
        list.append(self.vcell_mV)
        list.append(self.icell_mA)
        self.signalComData.emit(list)

    def batteryRest(self,restTime):
        if self.startTestFlag == 1:  #jump outof test if startTestFlag=0
            self.inst.write("smua.source.output = smua.OUTPUT_OFF")  # Turn off output.
            self.inst.write("smua.source.func = smua.OUTPUT_DCVOLTS")  # Select voltage source function.
            self.inst.write("smua.source.autorangev = smua.AUTORANGE_ON")  # Set current source range to autorange
            self.inst.write("smua.source.levelv = 4")  # Set current source to A.
            self.inst.write("smua.source.limiti = 1")

                    # Create a timer
            startTime = time.time()
            while True:
                self.smMeasure(restTimeStep_s)

                #Get out of while loop
                if self.startTestFlag == 0:#Terminate the test by cliking the "Finish test" button
                    break
                if (time.time() - startTime)>=restTime:
                    break
                else:
                    time.sleep(restTimeStep_s - ((time.time() - startTime) % restTimeStep_s))


    def constantCurrent(self, constantCurrent_mA, voltLowThd_mV, voltHighThd_mV,runTimeLimit=-1):
        if self.startTestFlag == 1:
            self.smPerSet(0,constantCurrent_mA,4250,battCapacity*0.8)
            # Create a timer
            startTime = time.time()
            while True:
                self.smMeasure(runTimeStep_s)

                #Get out of while loop
                if self.startTestFlag == 0:  # Terminate the test by cliking the "Finish test" button
                    break
                if self.vcell_mV < voltLowThd_mV or self.vcell_mV > voltHighThd_mV or (time.time() - startTime) < runTimeLimit:
                    break
                else:
                    time.sleep(runTimeStep_s - ((time.time() - startTime) % runTimeStep_s))

    """*********************************************************************************
    	Current is changed with step from mincurrent to maxcurrent, used to check the accuracy of MCU current detection.
    *********************************************************************************"""
    def changeCurrent(self, startCurrent_mA, endCurrent_mA, voltLowThd_mV,voltHighThd_mV,currentStep_mA, currentKeepTime_s):
        if self.startTestFlag == 1:
            # Used for excel save
            runTimeCurrent_mA = startCurrent_mA
            state = 0
            counter = 0

            if startCurrent_mA<endCurrent_mA:
                direction = 1
            else:
                direction = -1

            # Create a timer
            startTime = time.time()
            recordTime = time.time()

            while True:
                #Change current
                if state == 0:
                    self.smPerSet(0, runTimeCurrent_mA, voltHighThd_mV, battCapacity * 0.8)  # Per set the current to
                    runTimeCurrent_mA += currentStep_mA*direction
                    counter += 1
                    state = 2
                elif state == 1:
                    self.constantCurrentSet(runTimeCurrent_mA)
                    runTimeCurrent_mA += currentStep_mA*direction
                    counter += 1
                    state = 2
                elif state == 2:
                    counter += 1
                    if counter >= (currentKeepTime_s/runTimeStep_s):
                        counter = 0
                        state = 1
                    if runTimeCurrent_mA>endCurrent_mA and direction==1:
                        break
                    if runTimeCurrent_mA<endCurrent_mA and direction==-1:
                        break

                self.smMeasure(runTimeStep_s)

                # Get out of while loop
                if self.startTestFlag == 0:#Terminate the test by cliking the "Finish test" button
                    break
                if self.vcell_mV < voltLowThd_mV or self.vcell_mV > voltHighThd_mV:
                    break
                else:
                    time.sleep(runTimeStep_s - ((time.time() - startTime) % runTimeStep_s))


    def batteryCharging(self, chargeVoltage_mV,LimitCurrent_mA, terminateCurrent_mA ):
        if self.startTestFlag == 1:
            self.smPerSet(chargeVoltage_mV, 0, 4250, LimitCurrent_mA)
            # Create a timer
            startTime = time.time()
            while True:
                self.smMeasure(runTimeStep_s)

                #Get out of while loop
                if self.startTestFlag == 0:#Terminate the test by cliking the "Finish test" button
                    break
                if (self.icell_mA < terminateCurrent_mA and self.icell_mA >- terminateCurrent_mA) or self.icell_mA<0:
                    break
                else:
                    time.sleep(runTimeStep_s - ((time.time() - startTime) % runTimeStep_s))

    def pluseCurrent(self, constantCurrentA_mA, constantCurrentB_mA, ocvThdAtoB_mV, voltLowThd_mV, voltHighThd_mV,
                          workTime, restTime):
        if self.startTestFlag == 1:
            state = "Run"
            #Other functions should be run before this one to get vcell_mV
            if self.vcell_mV>ocvThdAtoB_mV: #When voltage above threshould
                self.smPerSet(0, constantCurrentA_mA, voltHighThd_mV+50, battCapacity*0.8)
            if self.vcell_mV<ocvThdAtoB_mV: #when voltage below threshould, as the change fast, need to lower the current
                self.smPerSet(0, constantCurrentB_mA, voltHighThd_mV+50, battCapacity*0.8)

            # Create a timer
            startTime = time.time()
            recordTime = time.time()
            while True:
                #Switch between run and rest mode
                if state == "Run":
                    if time.time()-recordTime >= workTime:
                        self.inst.write("smua.source.output = smua.OUTPUT_OFF")
                        recordTime= time.time() #init startTimeCycles
                        state = "Rest"
                    else:
                        self.inst.write("smua.source.output = smua.OUTPUT_ON")
                elif state == "Rest":
                    if time.time()-recordTime >= restTime:
                        self.inst.write("smua.source.output = smua.OUTPUT_ON")
                        if self.vcell_mV > ocvThdAtoB_mV:  # When voltage above threshould
                            self.constantCurrentSet(constantCurrentA_mA)
                        if self.vcell_mV < ocvThdAtoB_mV:  # when voltage below threshould, as the change fast, need to lower the current
                            self.constantCurrentSet(constantCurrentB_mA)
                        recordTime = time.time()  # init startTimeCycles
                        state = "Run"
                    else:
                        self.inst.write("smua.source.output = smua.OUTPUT_OFF")

                if state =="Run":
                    self.smMeasure(runTimeStep_s)
                elif state =="Rest":
                    self.smMeasure(restTimeStep_s)

                #Get out of while loop
                if self.startTestFlag == 0:#Terminate the test by cliking the "Finish test" button
                    break
                if self.vcell_mV <= voltLowThd_mV or self.vcell_mV >= voltHighThd_mV:
                    break
                else:
                    if state == "Run":
                        time.sleep(runTimeStep_s - ((time.time() - startTime) % runTimeStep_s))
                    elif state == "Rest":
                        time.sleep(restTimeStep_s - ((time.time() - startTime) % restTimeStep_s))
    def constantCurrentSet(self, current_mA):
        self.inst.write("smua.source.leveli = " + str(current_mA/1000))  # Set current source to A

    def paramFileConversion(self, fileName):
        #############################################Load SMData#############################################
        self.batRunFile = []
        self.state = 0
        self.Qmax = 0
        self.Quse = 0
        self.outPutData = []
        try:
            self.excelFile = openpyxl.load_workbook(fileName)
            self.excelSheet = self.excelFile.get_sheet_by_name("Sheet")
            rows = self.excelSheet.max_row
            for i in range(2,rows+1):
                if "SmData" in fileName:
                    self.batRunFile.append({"timeCount": self.excelSheet.cell(row=i, column=1).value,
                                            "realVcell": self.excelSheet.cell(row=i, column=2).value,
                                            "realIcell": self.excelSheet.cell(row=i, column=3).value})
                else:
                    self.batRunFile.append({"timeCount": self.excelSheet.cell(row=i, column=1).value,
                                            "realVcell": self.excelSheet.cell(row=i, column=3).value,
                                            "realIcell": self.excelSheet.cell(row=i, column=4).value})
        except:
            self.signalComLog.emit("Load SmData failed!")
        
        #############################################Handle SMData#############################################
        self.lastVcell_V = self.batRunFile[0].get("realVcell")/1000
        self.curVcell_V = self.batRunFile[0].get("realVcell")/1000
        self.lastIcell_A = self.batRunFile[0].get("realIcell")/1000
        self.curIcell_A = self.batRunFile[0].get("realIcell")/1000

        #Remove the first charging data
        for i in range(len(self.batRunFile)):
            if self.batRunFile[i]["realIcell"]/1000<(0-terminateCurtThd):
                startcount = i-1
                break
        if(startcount<0):
            self.signalComLog.emit("input file doesn't meet requirement!")

        for i in range(startcount, len(self.batRunFile)):
                self.Qmax += self.batRunFile[i]["realIcell"]/1000 * timeStep
        if self.Qmax < 0:  # discharge
            self.SocStart = 1# Treat the first reset as 100% SOC
        else:
            self.SocStart = 0

        for i in range(startcount,len(self.batRunFile)):
            # Load battery parameters
            self.lastVcell_V = self.curVcell_V
            self.lastIcell_A = self.curIcell_A

            self.curVcell_V = self.batRunFile[i].get("realVcell")/1000
            self.curIcell_A = self.batRunFile[i].get("realIcell")/1000
            self.curTimecount = i+1
            self.Quse += self.curIcell_A * timeStep

            if self.state == 0: # when change from rest to CHG or DHG for the first time
                if (abs(self.lastIcell_A) < terminateCurtThd and abs(self.curIcell_A) > terminateCurtThd):
                    self.ohmRes = (self.curVcell_V - self.lastVcell_V) / self.curIcell_A
                    self.ocv = self.lastVcell_V
                    self.soc = self.SocStart
                    self.outPutData.append([self.ohmRes, 0, 0, 0, 0, self.ocv, self.soc, 0])
                    self.state = 1
            if self.state == 1:  # start to rest
                if (abs(self.lastIcell_A) > terminateCurtThd and abs(self.curIcell_A) < terminateCurtThd):
                    self.ohmRes = (self.lastVcell_V-self.curVcell_V)/self.lastIcell_A
                    self.vcellUnderI = self.lastVcell_V

                    self.recrodI = self.lastIcell_A
                    self.startCount = self.curTimecount+tcShiftPoint  #Used to calculate Time constant
                    self.vcellwithoutI = self.batRunFile[i+tcShiftPoint].get("realVcell")/1000 #count = i+1
                    self.state = 2

            elif self.state == 2:  # start to charge or discharge
                if (abs(self.lastIcell_A) < terminateCurtThd and abs(self.curIcell_A) > terminateCurtThd) or i == len(self.batRunFile) - 1:
                    self.sumRes = (self.vcellUnderI-self.lastVcell_V)/self.recrodI #Vcell at last CNG/DG - Vcell at last Rest
                    self.polarRes =  self.sumRes-self.ohmRes
                    self.ocv = self.lastVcell_V
                    self.soc = self.SocStart + self.Quse/abs(self.Qmax)
                    #Get the voltage to calculate the time constant
                    self.VoltTcThd =self.vcellwithoutI + (self.lastVcell_V-self.vcellwithoutI) / 2.7182818
                    self.state = 3
                if i == len(self.batRunFile) - 1:
                    for b in range(self.startCount, len(self.batRunFile)):
                        if self.recrodI < 0:  # in discharge mode
                            if self.batRunFile[b].get("realVcell")/1000 > self.VoltTcThd:
                                self.curTc = b - self.startCount
                                self.polarCap = self.curTc / self.polarRes
                                self.outPutData.append(
                                    [self.ohmRes, self.polarRes, self.sumRes, self.polarCap, self.curTc, self.ocv,
                                     self.soc, self.Quse])
                                self.state = 1
                                break
                        else:
                            if self.batRunFile[b].get("realVcell")/1000 < self.VoltTcThd:
                                self.curTc = b - self.startCount
                                self.polarCap = self.curTc / self.polarRes
                                self.outPutData.append(
                                    [self.ohmRes, self.polarRes, self.sumRes, self.polarCap, self.curTc, self.ocv,
                                     self.soc, self.Quse])
                                self.state = 1
                                break
            elif self.state == 3:
                for b in range(self.startCount, len(self.batRunFile)):
                    if self.recrodI < 0:  # in discharge mode
                        if self.batRunFile[b].get("realVcell")/1000 > self.VoltTcThd:
                            self.curTc = b - self.startCount
                            self.polarCap = self.curTc / self.polarRes
                            self.outPutData.append(
                                [self.ohmRes, self.polarRes, self.sumRes, self.polarCap, self.curTc, self.ocv, self.soc,
                                 self.Quse])
                            self.state = 1
                            break
                    else:
                        if self.batRunFile[b].get("realVcell")/1000 < self.VoltTcThd:
                            self.curTc = b - self.startCount
                            self.polarCap = self.curTc / self.polarRes
                            self.outPutData.append(
                                [self.ohmRes, self.polarRes, self.sumRes, self.polarCap, self.curTc, self.ocv, self.soc,
                                 self.Quse])
                            self.state = 1
                            break

        #############################################Save data to excel#############################################
        self.excelSaveFile = openpyxl.Workbook()
        self.excelSaveSheet = self.excelSaveFile.get_sheet_by_name("Sheet")

        self.excelSaveSheet.cell(row=1, column=1).value = "sumResistor(Ω)"
        #  sumCapcitor = dSOC/docv
        self.excelSaveSheet.cell(row=1, column=2).value = "sumCapcitorFactor"
        self.excelSaveSheet.cell(row=1, column=3).value = "ocv(mV)"
        self.excelSaveSheet.cell(row=1, column=4).value = "soc(%)"
        self.excelSaveSheet.cell(row=1, column=5).value = "Quse(mAh)"
        self.excelSaveSheet.cell(row=1, column=6).value = "Qmax(mAh)"

        for i in range(len(self.outPutData)):
            self.excelSaveSheet.cell(row=i + 2, column=1).value = round(self.outPutData[i][2], 4)
            self.excelSaveSheet.cell(row=i + 2, column=3).value = round(self.outPutData[i][5] * 1000, 0)    #OCV
            self.excelSaveSheet.cell(row=i + 2, column=4).value = round(self.outPutData[i][6], 4)           #SOC
            # As/3.6 = mAh
            self.excelSaveSheet.cell(row=i + 2, column=5).value = round(self.outPutData[i][7], 4) / 3.6

        try:
            self.excelSaveSheet.cell(row=2, column=2).value = 0
            for i in range(1, len(self.outPutData)):
                # dSOC/dOCV*3.6
                self.excelSaveSheet.cell(row=i + 2, column=2).value = round(
                    3.6 * (self.outPutData[i][6] - self.outPutData[i - 1][6]) / (self.outPutData[i][5] - self.outPutData[i - 1][5]), 4)
        except:
            pass

        self.excelSaveSheet.cell(row=2, column=6).value = abs(self.Qmax) / 3.6
        self.excelSaveFile.save(datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-BatParamFile.xlsx")

        #############################################Save to txt#############################################
        self.handleData = []
        self.socTable = []
        self.ocvTable = []
        self.rcellTable = []
        self.capFactorTable = []

        try:
            rows =  self.excelSaveSheet.max_row
            for i in range(2, rows + 1):
                temp1 = self.excelSaveSheet.cell(row=i, column=4).value
                temp2 = self.excelSaveSheet.cell(row=i, column=3).value
                temp3 = self.excelSaveSheet.cell(row=i, column=1).value
                temp4 = self.excelSaveSheet.cell(row=i, column=2).value
                if temp4 == 0:
                    temp4 = self.excelSaveSheet.cell(row=i + 1, column=2).value
                if temp3 == 0:
                    temp3 = self.excelSaveSheet.cell(row=i + 1, column=1).value

                if temp1 == None or temp2 == None or temp3 == None or temp4 == None:
                    break
                else:
                    self.socTable.append(temp1)
                    self.ocvTable.append(temp2)
                    self.rcellTable.append(temp3)
                    self.capFactorTable.append(temp4)
        except:
            self.signalComLog.emit("Save TXT failed!")
        f = open(datetime.datetime.now().strftime('%Y-%m-%d-%H-%M')+ "-BatParamFile.txt",'w')
        f.write("#define CIRCUIT_TABLE_LENGTH           " + str(len(self.socTable))+" \n")
        f.write("tBattCircuitParams circuitParamsTable[] = { \n")
        for i in range(0, len(self.socTable)):
            f.write("{" + str(round(self.ocvTable[i])) + ",_IQ15(" + str(round(self.socTable[i], 4)) + "),_IQ15(" + str(
                round(self.capFactorTable[i], 4)) + "),_IQ15("+ str(round(self.rcellTable[i], 4)) + ")},\n")
        f.write("}; \n")
        f.close()
        self.signalComLog.emit("ParamFile creation success!")

    def runFileConversion(self, fileName):
        self.icellTable = []
        self.vcellTable = []
        self.Vcell_mV = []
        self.Icell_mA = []
        #############################################Load file#############################################
        try:
            self.excelFile = openpyxl.load_workbook(fileName)
            self.excelSheet = self.excelFile.get_sheet_by_name("Sheet")
            rows = self.excelSheet.max_row
            for i in range(2, rows + 1):
                if "SmData" in fileName:
                    temp1 = self.excelSheet.cell(row=i, column=2).value
                    temp2 = self.excelSheet.cell(row=i, column=3).value
                else:
                    temp1 = self.excelSheet.cell(row=i, column=3).value
                    temp2 = self.excelSheet.cell(row=i, column=4).value
                self.Vcell_mV.append(temp1)
                self.Icell_mA.append(temp2)
        except:
            self.signalComLog.emit("Load SmData/McuData failed!")
        #############################################Save Text#############################################
        count = 0
        sumCHG = 0
        sumDHG = 0
        f = open(datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-BatRunFile.txt", 'w')
        f.write("#include \"Gauge_UserConfig.h\""+"\n")
        f.write("#define DATA_RUN_FILE ("+str(int(len(self.Icell_mA)/compress))+")\n");
        f.write("const int16_t i16BattRunFile[] = {\n")
        # Remove the first data which is the wrong data get from source meter
        for i in range(1,len(self.Icell_mA)):
            if compress != 1:
                if i%compress == 1: #compress data
                    f.write( str(round(self.Icell_mA[i])) + "," + str(round(self.Vcell_mV[i]))+",\n")
                    if self.Icell_mA[i]>0:
                        sumCHG += self.Icell_mA[i]*compress
                    else:
                        sumDHG += self.Icell_mA[i]*compress
                    count+=1
            else: #compress = 1
                f.write( str(round(self.Icell_mA[i])) + "," + str(round(self.Vcell_mV[i]))+",\n")
                if self.Icell_mA[i]>0:
                    sumCHG += self.Icell_mA[i]
                else:
                    sumDHG += self.Icell_mA[i]
                count+=1
        f.write("};")
        f.close()
        self.signalComLog.emit("RunFile creation success!")
        self.signalComLog.emit("SumDHG = " +str(round(sumDHG/3600,1))+", SumCHG = "+str(round(sumCHG/3600,1)))
        #############################################Save Excel#############################################
        sumCHG = 0
        sumDHG = 0
        self.aexcelFile = openpyxl.Workbook()
        self.aexcelSheet = self.aexcelFile.get_sheet_by_name('Sheet')
        self.aexcelSheet.cell(row=1, column=1).value = "Icell_mA"
        self.aexcelSheet.cell(row=1, column=2).value = "Vcell_mV"

        f = open(datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-BatRunFile.txt", 'r')
        # Remove the first data which is the wrong data get from source meter
        res = f.readlines()
        for i in range(3, len(res) - 1):
            if (int(res[i][:-7]) > 0):
                sumCHG += int(res[i][:-7]) * compress
            else:
                sumDHG += int(res[i][:-7]) * compress
            self.aexcelSheet.cell(row=i-1, column=1).value = int(res[i][:-7])
            self.aexcelSheet.cell(row=i-1, column=2).value = int(res[i][-6:-2])
        self.aexcelFile.save(datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-BatRunFile.xlsx")